dofile(LockOn_Options.common_script_path.."elements_defs.lua")

ODU_DEFAULT_LEVEL     = 5

SetScale(FOV)

odu_scale		= 0.55/275
odu_grid_scale	= 0.50/275
odu_hdg_scale	= 0.70/275
odu_hdg_displ	= (3448 * odu_hdg_scale / 480) * GetScale()

symbol_pixels_x =  44.0 * 2 -- pi
symbol_pixels_y =  72.0 * 2

--- Colors Definitions ---

ODU_GREEN	= {0, 255, 100, 255}

---- Fonts Definition ----
local resources_path_f = LockOn_Options.script_path.."Resources/Fonts/"

ODU_default_font_size    = {0.010, 0.010}

ODU_xsize = 146
ODU_ysize = 146

local odu_font_desc = {
	texture		= resources_path_f.."font_UFC_AV8B.dds",
	size		= {7, 7},
	resolution	= {1024, 1024},
	default		= {ODU_xsize, ODU_ysize},
	chars		= {
		[1]		= {32,	ODU_xsize, ODU_ysize},	-- SPACE
		[2]		= {48,	ODU_xsize, ODU_ysize},	-- 0
		[3]		= {49,	ODU_xsize, ODU_ysize},	-- 1
		[4]		= {50,	ODU_xsize, ODU_ysize},	-- 2
		[5]		= {51,	ODU_xsize, ODU_ysize},	-- 3
		[6]		= {52,	ODU_xsize, ODU_ysize},	-- 4
		[7]		= {53,	ODU_xsize, ODU_ysize},	-- 5
		[8]		= {54,	ODU_xsize, ODU_ysize},	-- 6
		[9]		= {55,	ODU_xsize, ODU_ysize},	-- 7
		[10]	= {56,	ODU_xsize, ODU_ysize},	-- 8
		[11]	= {57,	ODU_xsize, ODU_ysize},	-- 9
		[12]	= {126,	ODU_xsize, ODU_ysize},	-- ~
		[13]	= {65,	ODU_xsize, ODU_ysize},	-- A
		[14]	= {66,	ODU_xsize, ODU_ysize},	-- B
		[15]	= {67,	ODU_xsize, ODU_ysize},	-- C
		[16]	= {68,	ODU_xsize, ODU_ysize},	-- D
		[17]	= {69,	ODU_xsize, ODU_ysize},	-- E
		[18]	= {70,	ODU_xsize, ODU_ysize},	-- F
		[19]	= {71,	ODU_xsize, ODU_ysize},	-- G
		[20]	= {72,	ODU_xsize, ODU_ysize},	-- H
		[21]	= {73,	ODU_xsize, ODU_ysize},	-- I
		[22]	= {74,	ODU_xsize, ODU_ysize},	-- J
		[23]	= {75,	ODU_xsize, ODU_ysize},	-- K
		[24]	= {76,	ODU_xsize, ODU_ysize},	-- L
		[25]	= {77,	ODU_xsize, ODU_ysize},	-- M
		[26]	= {78,	ODU_xsize, ODU_ysize},	-- N
		[27]	= {79,	ODU_xsize, ODU_ysize},	-- O
		[28]	= {80,	ODU_xsize, ODU_ysize},	-- P
		[29]	= {81,	ODU_xsize, ODU_ysize},	-- Q
		[30]	= {82,	ODU_xsize, ODU_ysize},	-- R
		[31]	= {83,	ODU_xsize, ODU_ysize},	-- S
		[32]	= {84,	ODU_xsize, ODU_ysize},	-- T
		[33]	= {85,	ODU_xsize, ODU_ysize},	-- U
		[34]	= {86,	ODU_xsize, ODU_ysize},	-- V
		[35]	= {87,	ODU_xsize, ODU_ysize},	-- W
		[36]	= {88,	ODU_xsize, ODU_ysize},	-- X
		[37]	= {89,	ODU_xsize, ODU_ysize},	-- Y
		[38]	= {90,	ODU_xsize, ODU_ysize},	-- Z
		[39]	= {47,	ODU_xsize, ODU_ysize},	-- /
		[40]	= {95,	ODU_xsize, ODU_ysize},	-- _ 
		[41]	= {58,	ODU_xsize, ODU_ysize},	-- :
		[42]	= {42,	ODU_xsize, ODU_ysize},	-- *
		[43]	= {44,	ODU_xsize, ODU_ysize},	-- ,
		[44]	= {64,	ODU_xsize, ODU_ysize},	-- @
		[45]	= {46,	ODU_xsize, ODU_ysize},	-- .
		[46]	= {39,	ODU_xsize, ODU_ysize},	-- '
		[47]	= {45,	ODU_xsize, ODU_ysize},	-- -
		[48]	= {33,	ODU_xsize, ODU_ysize},	-- !
		[49]	= {124,	ODU_xsize, ODU_ysize},	-- |
	}
}

odu_font_base	= MakeFont(odu_font_desc, ODU_GREEN,	"odu_font_base")


----- ODU Functions -----
function Add_ODU_Element(object)
	object.use_mipfilter      = true
	object.h_clip_relation    = h_clip_relations.COMPARE
	object.level			  = ODU_DEFAULT_LEVEL
	object.additive_alpha     = true --additive blending
	object.collimated 		  = false
	Add(object)
end
